#ifndef F_CPU									
#define F_CPU 12288000UL                       
#endif

#define Clock_I2C 100000L						

#include <avr/interrupt.h>					

#define CLR_BIT(PORT, BIT)  ((PORT) &= ~(1 << (BIT)))

uint8_t TWI_Adress_Slave = 0b01010000;
uint8_t TWI_AddressMask = 0b11111110;

unsigned char prescaler   = 60;  
unsigned char clk10ms_count = 10; 

uint8_t timertick;                 
uint8_t clk10ms;                

int main(void)
{
	TCCR0A  |= (0<<WGM00) |  (0<<WGM01);			
	TCCR0B  |= (0<<WGM02) |  (1<<CS01 );			
	TIMSK0  |= (1<<TOIE0);							
	
	sei();						
	
	TWSR = CLR_BIT (TWSR, TWPS0);				
	TWSR = CLR_BIT (TWSR, TWPS1);
	TWCR = 0;
	TWBR = ((F_CPU/Clock_I2C)-16)/2;				

	TWAR = (TWI_Adress_Slave << 1);			
	TWAMR = TWI_AddressMask;				
	TWCR = (1<<TWEA)|(1<<TWEN)|(1<<TWIE);	

	while (1)
	{	
		if (clk10ms)
		{
			clk10ms=0;

			TWSR = CLR_BIT (TWSR, TWPS0);					//TWI Reset	
			TWSR = CLR_BIT (TWSR, TWPS1);
			TWCR = 0;
			TWBR = ((F_CPU/Clock_I2C)-16)/2;				

			TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);		//TWI Start 			
			while (!(TWCR & (1 << TWINT)));								
			
			TWDR = (TWI_Adress_Slave << 1) + 1;				//TWI Address
			TWCR = (1 << TWINT) | (1 << TWEN);							
			while (!(TWCR & (1 << TWINT)));							
			
			TWCR = (1<<TWINT) | (1<<TWEN) | (1<<TWEA);		//TWI Slave msg
			while(!(TWCR & (1<<TWINT)));				

			PORTB=  TWDR;								

			TWCR = (1<<TWINT)|(1<<TWSTO)|(1<<TWEN);			//TWI Stop
			while (TWCR & (1<<TWSTO));					
		}
	}
}

ISR(TIMER0_OVF_vect)
{
    --prescaler;					
    if (prescaler==0)						
    {
        prescaler = 60;			
        clk10ms = 1;				
        --clk10ms_count;				
    }
}
