/*
 * LCD driver PCD8544 
 * 
 *					Adapted by Tim Fischer
 *					Based on code of Marian Hrinko (mato.hrinko@gmail.com)
 *
 * Author			Tim Fischer, Marian Hrinko
 * Date				23.05.2020
 * Description		Library designed for LCD with PCD8544 driver
 *					LCD Resolution 48x84
 *					Communication through 5 control wires (SCK, RST, DIN, CE, CS)
 */

#ifndef __PCD_H__
	#define __PCD_H__

	#ifndef		PCD_PORT
		#define PCD_PORT PORTB
	#endif
	#ifndef		PCD_DDR
		#define PCD_DDR  DDRB
	#endif
	#ifndef		PCD_CLK_PIN
		#define PCD_CLK_PIN  PB5	// serial Clock
	#endif
	#ifndef		PCD_RST_PIN
		#define PCD_RST_PIN  PB4	// Reset
	#endif
	#ifndef		PCD_DIN_PIN
		#define PCD_DIN_PIN  PB3	// MOSI, Data INput
	#endif
	#ifndef		PCD_CS_PIN
		#define PCD_CS_PIN   PB2	// Chip Select, Chip Enable
	#endif
	#ifndef		PCD_DC_PIN
		#define PCD_DC_PIN   PB1	// Data/Command selection line
	#endif

	#define MAX_NUM_ROWS 6			// 6 Zeilen sind in Pixel 6x8 = 48
	#define MAX_NUM_COLS 84
	#define PCD_BUFFER_SIZE (MAX_NUM_ROWS * MAX_NUM_COLS)

		// initialize the pcd8544 controller
	void pcd_init(void);

		// write command to display 
		// unsigned char - type (CMD or DATA)
		// unsigned char - data
	void pcd_write(unsigned char type, unsigned char data);

		// reset impulse to enable display
	void pcd_enable(void);

		// clear display
	void pcd_clearDisplay(void);

		// update display
	void pcd_updateDisplay(void);

		// put character on display
		// unsigned char - character
	char pcd_putc(unsigned char character);

		// put string on display
		// char* - string 
	void pcd_putstr(char *string);

		// goto text position in line on pos
		// unsigned char x - position 0 <= line <=  5
		// unsigned char y - position 0 <= pos  <= 14
	char pcd_gotoxy(unsigned char line, unsigned char pos);

		// update pixel position x, y on display
		// unsigned char x - position 0 <= x <= 83
		// unsigned char y - position 0 <= y <= 47
	char pcd_updatePixelxy(unsigned char x, unsigned char y);

		// put pixel on display
		// unsigned char x - position 0 <= x <= 83
		// unsigned char y - position 0 <= y <= 47
	char pcd_putPixel(unsigned char x, unsigned char y);

		// put line by Bresenham algoritm
		// https://en.wikipedia.org/wiki/Bresenham%27s_line_algorithm
		//
		// unsigned char x1 - start x position 0 <= x1 <= 83
		// unsigned char y1 - start y position 0 <= y1 <= 47
		// unsigned char x2 - end   x position 0 <= x2 <= 83
		// unsigned char y2 - end   y position 0 <= y2 <= 47
	char pcd_putLine(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2);
#endif

