/* ----------------------------------------------------------------------------
  
 Experiment 10:   I2C Kommunikation
 =============    ===============================
  
 Dateiname		: I2C_SimpleSlave.c
  
 Autoren		: Tim Fischer       (Hochschule Heilbronn, Fakultaet TE)
  
 Datum			: 18.11.2023
  
 Version		: 1.0
   
 Hardware		:  Simulide 0.5.16-RC5
  
 Software		:  Entwicklungsumgebung: AtmelStudio 7.0
				   C-Compiler: AVR/GNU C Compiler 5.4.0
   
 Funktion		: TBD
 
 Displayanzeige	: keine
 
 Tastenfunktion	: Die Tastenstellung der Dip-Schalter an Port B werden als Wert ber I2C weitergegeben.
				  Dabei zhlt ein gedrckter Schalter (= hellgrn) als logisches High Signal
 
 Jumperstellung	:  keine
 
 Fuses im uC	: keine
  
   
// ----------------------------------------------------------------------------*/
  
// Deklarationen ==============================================================
  
// Festlegung der Quarzfrequenz
#define F_CPU 8000000UL									// CPU Frequenz von 8MHz
#define F_SCL   100000L									// Baudrate von 100 kHz
 
// Include von Header-Dateien
#include <avr/interrupt.h>
 
// Konstanten
#define SET_BIT(BYTE, BIT)  ((BYTE) |=  (1 << (BIT)))	// Bit Zustand in Byte setzen
#define CLR_BIT(BYTE, BIT)  ((BYTE) &= ~(1 << (BIT)))	// Bit Zustand in Byte loeschen
#define TGL_BIT(BYTE, BIT)  ((BYTE) ^=  (1 << (BIT)))	// Bit Zustand in Byte wechseln (toggle)

#define SET_ALL_TO_OUT		(0xFF)						// Konstante fr die Aktivierung der Port Ausgnge
#define TWI_ADRESS			(0b0001010)					// Konstante fr die I2C Adresse
#define TWI_ADRESS_MASK		(0b0001010)					// Konstante fr die I2C Adress-Maske
 
//Funktionsprototypen
void I2C_Init();
void I2C_setAddress(char Address);
char I2C_readData();
 
uint8_t TWI_Address         = TWI_ADRESS;				// Variable der I2C Adresse 
uint8_t TWI_AddressMask     = TWI_ADRESS_MASK;			// Variable Zum maskieren der eingehenden Adresse
 
int main(void)
{
    DDRB= SET_ALL_TO_OUT;								// Auf DDRC die Daten ausgeben
    I2C_setAddress(TWI_Address);						// eigene Adresse setzen
     
    while (1) 
    {
        PORTB = I2C_readData();							// Daten an PortC ausgeben
    } 
}
 
//////////////////////////////////////////////////
// Setzen der I2C Adresse auf die der Slave hrt
//////////////////////////////////////////////////
void I2C_setAddress(char Address)                       
{
    TWAR = (Address<<1);								// Adresse in das Pseudoregister schreiben
    TWAMR= TWI_AddressMask;                             // Adressmaske in das Pseudoregister schreiben
    TWCR = (1<<TWEA)|(1<<TWEN);                         // Enable Ack, Enable Interupt und Enable TIW
}
 
//////////////////////////////////////////////////
// Auslesen der bermittelten Daten 
//////////////////////////////////////////////////
char I2C_readData()                     
{
    while (!(TWCR & (1<<TWINT)));						// warte solange bis TWINT gesetzt ist
    return TWDR;                                        // bermittle Daten
}