#define F_CPU				16000000UL

#include <avr/io.h>
#include <util/delay.h>
#include <stdint.h>

#define SET_BIT(BYTE, BIT)  ((BYTE) |=  (1 << (BIT)))
#define CLR_BIT(BYTE, BIT)  ((BYTE) &= ~(1 << (BIT)))

#define SLAVE_REQUEST		0x11			// The value can be changed

void SPI_MasterTransmit(uint8_t data);

int main() 
{											// Set the following Pins as output
	DDRB =	 (1<<DDB2)						//  - !SS 
			|(1<<DDB3)						//  - MOSI
			|(1<<DDB4)						//  - MOSI
			|(1<<DDB5); 					//  - SCK
	SPCR =   (1<<SPE)|(1<<MSTR)|(1<<SPR0);	// Enable SPI, Master mode, clock rate fck/16
	
	DDRD = 0xFF;							// Set PORTD as output
	
	while(1) {
		SPI_MasterTransmit(SLAVE_REQUEST);	// Send request to slave

		uint8_t dataFromSlave = SPDR;		// Receive the answer from the slave
		PORTD = dataFromSlave^0xFF;			// Output the answer on PORTC, but all Bits inverted 
	}
}

void SPI_MasterTransmit(uint8_t data) 
{
	CLR_BIT(PORTB, PORTB2);					// clear !SS to activate Slave
	SPDR = data;							// Start transmission
	while(!(SPSR & (1<<SPIF)));				// Wait for transmission complete
	SET_BIT(PORTB, PORTB2);					// Set !SS to deactivate Slave
}

