#include <avr/io.h>
#include <avr/interrupt.h>

#define SLAVE_REQUEST		0x11		// The value can be changed

volatile uint8_t dataToMaster	= 0x00;
volatile uint8_t dataFromMaster = 0x00;

int main() {
	DDRB = (1<<DDB4);					// MISO as output
	PORTD = 0xFF;						// Activate all pull-up resistors for PIND, to read switch states correctly
	SPCR = (1<<SPE)|(1<<SPIE);			// Enable SPI and SPI interrupt
	sei();								// Enable global interrupts

	while(1) 
	{
										// Main application code
	}
}

ISR(SPI_STC_vect) {
	dataFromMaster = SPDR;
	if (dataFromMaster == SLAVE_REQUEST)
	{
		dataToMaster=PIND;
		SPDR = dataToMaster;			// Load data into the buffer		
	}
}

