// Deklarationen ==============================================================

// Festlegung der Quarzfrequenz
#ifndef F_CPU                   								// optional definieren
#define F_CPU 18432000UL        								// ATmega328 mit 18,432 MHz Quarz
#endif

// Include von Header-Dateien
#include "lcd_lib_de.h"         								// Funktionsbibliothek zum LCD-Display
#include <avr/pgmspace.h>

// Schreiben der Daten ins Flash
const char				string_0[] PROGMEM = "- Menutext 1 -";	// string_0 etc werden als Strings im Flash abgelegt
const char				string_1[] PROGMEM = "- Menutext 2 -";
const char				string_2[] PROGMEM = "- Menutext 3 -";
const char				string_3[] PROGMEM = "- Menutext 4 -";
const char				string_4[] PROGMEM = "- Menutext 5 -";
const char				string_5[] PROGMEM = "- Menutext 6 -";
const char *const   string_table[] PROGMEM = {string_0, string_1, string_2, string_3, string_4, string_5};
// Auch die Array-Struktur wird im Flash abgelegt

char buffer[15];												// Im Datenspeicher wird ein Buffer angelegt.
// WICHTIG: die Lnge des Buffers muss um 1 Byte grer sein, als der lngste String!
// Hauptprogramm ==============================================================
int main()
{
	lcd_init();													// Initialisierungsroutine aus der lcd_lib

	strcpy_P(buffer, (char *)pgm_read_ptr(&(string_table[0]))); // Necessary casts and dereferencing, just copy.
	lcd_gotoxy(0,0);											// Cursor auf 1. Zeile, 1. Zeichen
	lcd_putstr(buffer);											// Ausgabe Festtext: 16 Zeichen
	
	strcpy_P(buffer, (char *)pgm_read_ptr(&(string_table[1]))); // Necessary casts and dereferencing, just copy.
	lcd_gotoxy(1,0);											// Cursor auf 2. Zeile, 1. Zeichen
	lcd_putstr(buffer);											// Ausgabe Festtext: 16 Zeichen
	
	while(1)   {}												// Endlosschleife
	
}
