/*=============================================================================

Projekt: WS2812
Autoren:		Tim Fischer

Version:		1.1 vom 15.06.2018
=============================================================================*/

/*** -RZ- ***/
#ifndef F_CPU					// optional definieren
#define F_CPU 10000000UL		// MEXLE mit 12,288 MHz Quarz
#endif
/*** ENDE ***/
 
#include <util/delay.h>			//bentigte Libraries einbinden
#include <avr/io.h>
#include <avr/interrupt.h>
#include "light_ws2812.h"		//light_ws2812.h, light_ws2812.c und ws2812_config.h zu Project hinzufgen
#include <stdbool.h> 			// Bibliothek fuer Bit-Variable


#define VORTEILER_WERT 		60		// Faktor Vorteiler = 60
#define HUNDERTSTEL_WERT 	10	 	// Faktor Hundertstel = 10
#define ZEHNTEL_WERT	 	10	 	// Faktor Zehntel = 10


#define ANZLED 10					//Anzahl der LEDs eintragen

//Variablen
unsigned char vorteiler 	= VORTEILER_WERT;	// Zaehlvariable Vorteiler
unsigned char hundertstel 	= HUNDERTSTEL_WERT; // Zaehlvariable Hundertstel
unsigned char zehntel 		= ZEHNTEL_WERT;		// Zaehlvariable Zehntel
unsigned char sekunden 		= 3;				// Variable Sekunden
unsigned char minuten 		= 7;				// Variable Minuten
unsigned char stunden 		= 10;				// Variable Stunden

bool timertick;					// Bit-Botschaft alle 0,111ms (bei Timer-Interrupt)
bool takt10ms;					// Bit-Botschaft alle 10ms
bool takt100ms;					// Bit-Botschaft alle 100ms
bool takt1s;					// Bit-Botschaft alle 1s


void timerInt0(void);			// Init Zeitbasis mit Timer 0
void uhrZaehlen(void);			// Uhrfunktion
void ledAnsteuern(void);		// Ausgabe der Signale an WS2812

/*Atmel Studio: ber Project->Properties->Toolchain->AVR/GNU C Compiler->Symbols->Add Symbol "F_CPU=18432000UL"*/
/*In ws2812_config.h bei "#define ws2812_port" und "#define ws2812_pin" die entsprechenden Konstanten eintragen*/


struct cRGB led[ANZLED]; //Variablendeklaration

int main()
{	
	
	TCCR0A = 0;					// Timer 0 auf "Normal Mode" schalten
	TCCR0B |= (1<<CS01);		// mit Prescaler /8 betreiben
	TIMSK0 |= (1<<TOIE0);		// Overflow-Interrupt aktivieren
	sei();						// generell Interrupts einschalten
		
	int a=0;	
	while(1)					// unendliche Warteschleife mit Aufruf der
		// Funktionen abhaengig von Taktbotschaften
    {
	    if (takt100ms)           // alle 100ms:
	    {
		    takt100ms = 0;       //      Botschaft "100ms" loeschen
			a++;
			if (a>ANZLED) {a=0;};
			for(int b=0;b<ANZLED;b++)
			{
				led[b].r=0;led[b].g=0;led[b].b=0; //ursprngliche LED geht aus
			};
			led[a].r=255;led[a].g=0;led[a].b=0; //naechste LED geht aun

			ws2812_sendarray((uint8_t *)led,3*ANZLED);   
	    }
	    if (takt10ms)          // alle 100ms:
	    {
		    takt10ms = 0;      //      Botschaft "10ms" loeschen
	    }
    }
	return 0;
}

// Interrupt-Routine ==========================================================
ISR (TIMER0_OVF_vect)
/* In der Interrupt-Routine sind die Softwareteiler fr die Taktbotschaften 
   (10ms, 100ms) realisiert. Die Interrupts stammen von Timer 0 (Interrupt 1)
 
   Verwendete Variable: vorteiler
                        hunderstel
 
   Ausgangsvariable:    takt10ms
                        takt100ms
*/
{
    timertick = 1;                  // Botschaft 0,166ms senden
    --vorteiler;                    // Vorteiler dekrementieren
    if (vorteiler==0)               // wenn 0 erreicht: 10ms abgelaufen
    {
        vorteiler = VORTEILER_WERT; //    Vorteiler auf Startwert
        takt10ms = 1;               //    Botschaft 10ms senden
        --hundertstel;              //    Hunderstelzhler dekrementieren
 
        if (hundertstel==0)         // wenn 0 erreicht: 100ms abgelaufen
        {
            hundertstel = HUNDERTSTEL_WERT; // Teiler auf Startwert
            takt100ms = 1;          //    Botschaft 100ms senden
        }
    }
}